<?php

class TestModel9 extends CFormModel
{
	public $regon;

	public function rules()
	{
		return array(
			array('regon', 'ext.Validators.Regon9Validator'),
		);
	}
}

class TestModel9NoCk extends CFormModel
{
	public $regon;

	public function rules()
	{
		return array(
			array('regon', 'ext.Validators.Regon9Validator', 'disableChecksum' => true),
		);
	}
}

class TestModel14 extends CFormModel
{
	public $regon;

	public function rules()
	{
		return array(
			array('regon', 'ext.Validators.Regon14Validator'),
		);
	}
}

class TestModel14NoCk extends CFormModel
{
	public $regon;

	public function rules()
	{
		return array(
			array('regon', 'ext.Validators.Regon14Validator', 'disableChecksum' => true),
		);
	}
}

class RegonValidatorTest extends PHPUnit_Framework_TestCase
{
	/**
	 * @dataProvider dataProviderTestValidateAttribute
	 */
	public function testValidateAttribute($regon, $errors, $class = 'TestModel9')
	{
		$model = new $class();
		$model->regon = $regon;
		$this->assertEquals($regon, $model->regon);
		$model->validate();
		$this->assertEquals($model->errors, $errors);
	}

	public function dataProviderTestValidateAttribute()
	{
		static $data = array(
			//bad
			array('qwertyuio', array('regon'=>array('Pole Regon jest nieprawidłowe.'))),
			array('invalid nip', array('regon'=>array('Pole Regon jest nieprawidłowe.'))),
			array('1234', array('regon'=>array('Pole Regon jest nieprawidłowe.'))),
			array('', array()),
			array('7963342152', array('regon'=>array('Pole Regon jest nieprawidłowe.'))),
			array(null, array()),
			array(0, array()),
			array(false, array()),
			array(123, array('regon'=>array('Pole Regon jest nieprawidłowe.'))),
			array(6771731779, array('regon'=>array('Pole Regon jest nieprawidłowe.'))),
			array('47725557835981', array('regon'=>array('Pole Regon jest nieprawidłowe.'))),
			//good string
			array('474564273', array()),
			array('331811883', array()),
			array('255020953', array()),
			//good number
			array(357706999, array()),
			array(414882784, array()),
			//bad string
			array('474568273', array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.'))),
			array('331811893', array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.'))),
			array('254020953', array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.'))),
			//bad number
			array(357206999, array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.'))),
			array(414872784, array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.'))),
			//noick
			array('474568273', array(), 'TestModel9NoCk'),
			array('331811893', array(), 'TestModel9NoCk'),
			array('254020953', array(), 'TestModel9NoCk'),
			array('qwertyuio', array('regon'=>array('Pole Regon jest nieprawidłowe.')), 'TestModel9NoCk'),
			array('1234', array('regon'=>array('Pole Regon jest nieprawidłowe.')), 'TestModel9NoCk'),

			//TestModel14
			array('qwertyuiopasdfj', array('regon'=>array('Pole Regon jest nieprawidłowe.')), 'TestModel14'),
			array('474564273', array('regon'=>array('Pole Regon jest nieprawidłowe.')), 'TestModel14'),
			//good string
			array('47725557835981', array(), 'TestModel14'),
			array('41597389141253', array(), 'TestModel14'),
			array('01811027568923', array(), 'TestModel14'),
			//good number
			array(89112664039512, array(), 'TestModel14'),
			array(91215624212348, array(), 'TestModel14'),
			//bad string
			array('42225557835981', array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.')), 'TestModel14'),
			array('91597389141253', array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.')), 'TestModel14'),
			array('11811027568923', array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.')), 'TestModel14'),
			//bad number
			array(89112664039112, array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.')), 'TestModel14'),
			array(91215624212338, array('regon'=>array('Pole Regon ma niepoprawną sumę kontrolną.')), 'TestModel14'),
			//nock
			array('42225557835981', array(), 'TestModel14NoCk'),
			array('91597389141253', array(), 'TestModel14NoCk'),
			array('11811027568923', array(), 'TestModel14NoCk'),
			array('qwertyuiopasdfj', array('regon'=>array('Pole Regon jest nieprawidłowe.')), 'TestModel14NoCk'),
			array('474564273', array('regon'=>array('Pole Regon jest nieprawidłowe.')), 'TestModel14NoCk'),
		);
		return $data;
	}
}
